/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWAttachmentType;
import filenet.vw.api.VWException;
import filenet.vw.api.VWLibraryType;
import filenet.vw.api.VWXMLHandler;
import java.io.Serializable;
import java.util.StringTokenizer;

public final class VWAttachment
implements Serializable {
    private static final long serialVersionUID = 7552L;
    protected String attachmentName = null;
    protected String attachmentDescription = null;
    protected String id = null;
    protected String version = null;
    protected String library = null;
    protected int attachmentType = 0;
    protected int libraryType = 0;
    public static final char SEPARATOR = '|';

    public static String _get_FILE_DATE() {
        return "$Date: 2010-02-25 21:03:16 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Kevin Bentley;096657649;kbentley@us.ibm.com (kbentley) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_452_Int/PUI_460_Int/2 $";
    }

    public VWAttachment() {
    }

    public VWAttachment(String theValue) throws VWException {
        this.setValue(theValue);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String theId) throws VWException {
        if (theId != null && theId.indexOf(124) != -1) {
            throw new VWException("vw.api.VWAttachmentSeparatorNotAllowedInString", "Separator character not allowed in parameter value, illegal character ascii value is : {0}", Integer.toHexString(124));
        }
        this.id = theId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String theVersion) throws VWException {
        if (theVersion != null && theVersion.indexOf(124) != -1) {
            throw new VWException("vw.api.VWAttachmentSeparatorNotAllowedInString", "Separator character not allowed in parameter value, illegal character ascii value is : {0}", Integer.toHexString(124));
        }
        this.version = theVersion;
    }

    public String getLibraryName() {
        return this.library;
    }

    public void setLibraryName(String theLibraryName) throws VWException {
        if (theLibraryName != null && theLibraryName.indexOf(124) != -1) {
            throw new VWException("vw.api.VWAttachmentSeparatorNotAllowedInString", "Separator character not allowed in parameter value, illegal character ascii value is : {0}", Integer.toHexString(124));
        }
        this.library = theLibraryName;
    }

    public String getAttachmentName() {
        return this.attachmentName;
    }

    public void setAttachmentName(String theAttachmentName) throws VWException {
        if (theAttachmentName != null && theAttachmentName.indexOf(124) != -1) {
            throw new VWException("vw.api.VWAttachmentSeparatorNotAllowedInString", "Separator character not allowed in parameter value, illegal character ascii value is : {0}", Integer.toHexString(124));
        }
        this.attachmentName = theAttachmentName;
    }

    public String getAttachmentDescription() {
        return this.attachmentDescription;
    }

    public void setAttachmentDescription(String theAttachmentDescription) throws VWException {
        if (theAttachmentDescription != null && theAttachmentDescription.indexOf(124) != -1) {
            throw new VWException("vw.api.VWAttachmentSeparatorNotAllowedInString", "Separator character not allowed in parameter value, illegal character ascii value is : {0}", Integer.toHexString(124));
        }
        this.attachmentDescription = theAttachmentDescription;
    }

    public int getType() {
        return this.attachmentType;
    }

    public void setType(int theAttachmentType) throws VWException {
        if (!VWAttachmentType.isValid(theAttachmentType)) {
            throw new VWException("vw.api.VWAttachmentTypeInvalid", "The attachment type is invalid: {0}", String.valueOf(theAttachmentType));
        }
        this.attachmentType = theAttachmentType;
    }

    public int getLibraryType() {
        return this.libraryType;
    }

    public void setLibraryType(int theLibraryType) throws VWException {
        if (!VWLibraryType.isValid(theLibraryType)) {
            throw new VWException("vw.api.VWAttachmentLibraryTypeInvalid", "The library type is invalid: {0}", String.valueOf(theLibraryType));
        }
        this.libraryType = theLibraryType;
    }

    protected void setValue(String theNewValue) throws VWException {
        int tempAttachmentType = 0;
        int tempLibraryType = 0;
        String tempId = null;
        String tempLibrary = null;
        String tempVersion = null;
        String token = null;
        String tempName = null;
        String tempDescription = null;
        char delimiter = '|';
        String DELIM = String.valueOf(delimiter);
        if (theNewValue != null && theNewValue.length() != 0) {
            StringTokenizer stmp = new StringTokenizer(theNewValue, DELIM, true);
            if (stmp.hasMoreTokens()) {
                token = stmp.nextToken();
                if (!token.equals(DELIM)) {
                    tempName = token;
                    if (tempName != null && tempName.equals("null")) {
                        tempName = null;
                    }
                    if (!stmp.hasMoreTokens()) {
                        throw new VWException("vw.api.VWAttachmentMissingParts", "The new value is invalid.  Missing parts.({0}) {1}", "name", theNewValue);
                    }
                    token = stmp.nextToken();
                    if (!token.equals(DELIM)) {
                        throw new VWException("vw.api.VWAttachmentDelimiterExpected", "The new value is invalid.  Be sure to separate each part with a {0}. {1}", DELIM, theNewValue);
                    }
                }
            } else {
                throw new VWException("vw.api.VWAttachmentMissingParts", "The new value is invalid.  Missing parts.({0}) {1}", "name", theNewValue);
            }
            if (stmp.hasMoreTokens()) {
                token = stmp.nextToken();
                if (!token.equals(DELIM)) {
                    tempDescription = token;
                    if (tempDescription != null && tempDescription.equals("null")) {
                        tempDescription = null;
                    }
                    if (!stmp.hasMoreTokens()) {
                        throw new VWException("vw.api.VWAttachmentMissingParts", "The new value is invalid.  Missing parts.({0}) {1}", "description", theNewValue);
                    }
                    token = stmp.nextToken();
                    if (!token.equals(DELIM)) {
                        throw new VWException("vw.api.VWAttachmentDelimiterExpected", "The new value is invalid.  Be sure to separate each part with a {0}. {1}", DELIM, theNewValue);
                    }
                }
            } else {
                throw new VWException("vw.api.VWAttachmentMissingParts", "The new value is invalid.  Missing parts.({0}) {1}", "description", theNewValue);
            }
            if (stmp.hasMoreTokens()) {
                token = stmp.nextToken();
                if (!token.equals(DELIM)) {
                    try {
                        tempAttachmentType = Integer.parseInt(token);
                    }
                    catch (NumberFormatException e) {
                        throw new VWException("vw.api.VWAttachmentBadAttachmentType", "Attachment type is not an integer : {0}. {1}", token, theNewValue);
                    }
                    if (!VWAttachmentType.isValid(Integer.parseInt(token))) {
                        throw new VWException("vw.api.VWAttachmentInvalidAttachmentType", "Integer form of the attachment type is invalid: {0}. {1}", token, theNewValue);
                    }
                    if (!stmp.hasMoreTokens()) {
                        throw new VWException("vw.api.VWAttachmentMissingParts", "The new value is invalid.  Missing parts.({0}) {1}", "type", theNewValue);
                    }
                    token = stmp.nextToken();
                    if (!token.equals(DELIM)) {
                        throw new VWException("vw.api.VWAttachmentDelimiterExpected", "The new value is invalid.  Be sure to separate each part with a {0}. {1}", DELIM, theNewValue);
                    }
                }
            } else {
                throw new VWException("vw.api.VWAttachmentMissingParts", "The new value is invalid.  Missing parts.({0}) {1}", "type", theNewValue);
            }
            if (stmp.hasMoreTokens()) {
                token = stmp.nextToken();
                if (!token.equals(DELIM)) {
                    try {
                        tempLibraryType = Integer.parseInt(token);
                    }
                    catch (NumberFormatException e) {
                        throw new VWException("vw.api.VWAttachmentBadLibraryType", "Library type is not an integer : {0}. {1}", token, theNewValue);
                    }
                    if (!VWLibraryType.isValid(tempLibraryType)) {
                        throw new VWException("vw.api.VWAttachmentInvalidLibraryType", "Integer form of the library type is invalid: {0}. {1}", token, theNewValue);
                    }
                    if (!stmp.hasMoreTokens()) {
                        throw new VWException("vw.api.VWAttachmentMissingParts", "The new value is invalid.  Missing parts.({0}) {1}", "library_type", theNewValue);
                    }
                    token = stmp.nextToken();
                    if (!token.equals(DELIM)) {
                        throw new VWException("vw.api.VWAttachmentDelimiterExpected", "The new value is invalid.  Be sure to separate each part with a {0}. {1}", DELIM, theNewValue);
                    }
                }
            } else {
                throw new VWException("vw.api.VWAttachmentMissingParts", "The new value is invalid.  Missing parts.({0}) {1}", "library_type", theNewValue);
            }
            if (stmp.hasMoreTokens()) {
                token = stmp.nextToken();
                if (!token.equals(DELIM)) {
                    tempLibrary = token;
                    if (tempLibrary != null && tempLibrary.equals("null")) {
                        tempName = null;
                    }
                    if (!stmp.hasMoreTokens()) {
                        throw new VWException("vw.api.VWAttachmentMissingParts", "The new value is invalid.  Missing parts.({0}) {1}", "library_name", theNewValue);
                    }
                    token = stmp.nextToken();
                    if (!token.equals(DELIM)) {
                        throw new VWException("vw.api.VWAttachmentDelimiterExpected", "The new value is invalid.  Be sure to separate each part with a {0}. {1}", DELIM, theNewValue);
                    }
                }
            } else {
                throw new VWException("vw.api.VWAttachmentMissingParts", "The new value is invalid.  Missing parts.({0}) {1}", "library_name", theNewValue);
            }
            if (stmp.hasMoreTokens() && !(token = stmp.nextToken()).equals(DELIM)) {
                tempId = token;
                if (tempId != null && tempId.equals("null")) {
                    tempId = null;
                }
                if (stmp.hasMoreTokens() && !(token = stmp.nextToken()).equals(DELIM)) {
                    throw new VWException("vw.api.VWAttachmentDelimiterExpected", "The new value is invalid.  Be sure to separate each part with a {0}. {1}", DELIM, theNewValue);
                }
            }
            if (stmp.hasMoreTokens()) {
                tempVersion = stmp.nextToken();
                if (tempAttachmentType != 3 && tempAttachmentType != 0 && (tempAttachmentType != 4 || tempLibraryType != 3)) {
                    throw new VWException("vw.api.VWAttachmentVersionNotAllowed", "The new value is invalid.  Contains version ({0}, but attachment type ({1}) is not ATTACHMENT_TYPE_DOCUMENT or versionable ATTACHMENT_TYPE_STORED_SEARCH. {2}", tempVersion, String.valueOf(tempAttachmentType), theNewValue);
                }
            }
        }
        this.attachmentType = tempAttachmentType;
        this.libraryType = tempLibraryType;
        this.id = tempId;
        this.library = tempLibrary;
        this.attachmentName = tempName;
        this.attachmentDescription = tempDescription;
        this.version = null;
        if (tempVersion != null) {
            this.version = tempVersion;
        }
    }

    public String toString() {
        String retStr = "";
        if (this.attachmentName != null) {
            retStr = retStr + this.attachmentName;
        }
        retStr = retStr + '|';
        if (this.attachmentDescription != null) {
            retStr = retStr + this.attachmentDescription;
        }
        retStr = retStr + '|';
        retStr = retStr + this.attachmentType;
        retStr = retStr + '|';
        retStr = retStr + this.libraryType;
        retStr = retStr + '|';
        if (this.library != null) {
            retStr = retStr + this.library;
        }
        retStr = retStr + '|';
        if (this.id != null) {
            retStr = retStr + this.id;
        }
        if (this.version != null) {
            retStr = retStr + '|';
            retStr = retStr + this.version;
        }
        return retStr;
    }

    public void toXML(StringBuffer theBuffer) throws VWException {
        String INDENT_0 = "\t\t\t";
        String INDENT_1 = INDENT_0 + "\t";
        if (theBuffer == null) {
            throw new VWException("vw.api.VWAttachmentNullBuffer", "buffer parameter cannot be null.");
        }
        theBuffer.append(INDENT_0 + "<" + "Attachment");
        if (this.attachmentName != null) {
            theBuffer.append("\n" + INDENT_1 + "Name" + "=\"" + VWXMLHandler.toXMLString(this.attachmentName) + "\"");
        }
        if (this.attachmentDescription != null) {
            theBuffer.append("\n" + INDENT_1 + "Description" + "=\"" + VWXMLHandler.toXMLString(this.attachmentDescription) + "\"");
        }
        if (this.library != null) {
            theBuffer.append("\n" + INDENT_1 + "Library" + "=\"" + VWXMLHandler.toXMLString(this.library) + "\"");
        }
        if (this.id != null) {
            theBuffer.append("\n" + INDENT_1 + "Id" + "=\"" + VWXMLHandler.toXMLString(this.id) + "\"");
        }
        if (this.libraryType != 0) {
            theBuffer.append("\n" + INDENT_1 + "LibraryType" + "=\"" + VWXMLHandler.toXMLString(VWLibraryType.typeToString(this.libraryType)) + "\"");
        }
        if (this.attachmentType != 0) {
            theBuffer.append("\n" + INDENT_1 + "Type" + "=\"" + VWXMLHandler.toXMLString(VWAttachmentType.typeToString(this.attachmentType)) + "\"");
        }
        if (this.version != null) {
            theBuffer.append("\n" + INDENT_1 + "Version" + "=\"" + VWXMLHandler.toXMLString(this.version) + "\"");
        }
        theBuffer.append("/>\n");
    }
}

